package parser;

/**
 * Right parenthesis token class.
 */
public class RightPToken extends AToken {
    /**
     * Interface for a visitor to visit a right parenthesis token.
     */
    public static interface IRightPVisitor extends ITokVisitor {
        /**
         * Case for a right parenthesis token.
         *
         * @param host  right parenthesis token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object rightPCase(RightPToken host, Object param);
    }

    /**
     * Abstract class for a chained visitor to visit a plus token. In all non-plus cases, the successor is called.
     */
    public static abstract class AChainVis implements IRightPVisitor {
        /**
         * Successor.
         */
        private ITokVisitor _successor;

        /**
         * Constructor.
         *
         * @param successor visitor to serve as successor in the chain of responsibility.
         */
        protected AChainVis(ITokVisitor successor) {
            _successor = successor;
        }

        /**
         * Continue in the chain of responsibility.
         *
         * @param host  token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object defaultCase(AToken host, Object param) {
            return host.execute(_successor, param);
        }
    }

    /**
     * Singleton instance.
     */
    public final static RightPToken Singleton = new RightPToken();

    /**
     * Private singleton constructor.
     */
    private RightPToken() {
        super(")");
    }

    /**
     * Execute the right parenthesis case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof IRightPVisitor) ?
               ((IRightPVisitor) algo).rightPCase(this, param) :
               algo.defaultCase(this, param);
    }
}

